

import numpy as np
import matplotlib.pyplot as plt

import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--num', nargs = '+', type=int, required=True,
		help = 'List # you want to plot')

args = parser.parse_args()
make_plot = args.num

snr = np.arange(15,-5,-1)


plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
#viterbi_ber =[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.000030000150001e-06, 0.00010600053000265002, 0.0005640028200141001, 0.0022820114100570504, 0.006776033880169401, 0.017590087950439752, 0.03640418202091011, 0.06593432967164836, 0.10601253006265031, 0.15382276911384557, 0.20517702588512943, 0.26131730658653296, 0.3128455642278211, 0.36954184770923854, 0.4193120965604828, 0.4687823439117196, 0.5165805829029145, 0.5599167995839979]
#fir_ber = [0.0, 0.0, 0.0, 0.0, 0.0, 4.0000200001e-06, 4.8000240001200006e-05, 0.0002560012800064, 0.0010480052400262002, 0.0032940164700823505, 0.008832044160220801, 0.018870094350471753, 0.03632618163090815, 0.06085430427152136, 0.09541647708238542, 0.13733268666343332, 0.18458892294461474, 0.23581717908589542, 0.29120545602728015, 0.34521772608863044, 0.4029280146400732, 0.4540162700813504, 0.5041805209026046, 0.5536067680338401, 0.5969469847349237]
#dfe_ber = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2000060000300002e-05, 5.000025000125e-05, 0.00033200166000830003, 0.0015420077100385503, 0.0048880244401222, 0.012408062040310202, 0.026734133670668354, 0.049806249031245156, 0.08248641243206216, 0.12460062300311502, 0.17306286531432657, 0.22469512347561738, 0.28008940044700226, 0.33304966524832624, 0.3882519412597063, 0.4383321916609583, 0.4883844419222096, 0.5372926864634323, 0.5801149005745029]

viterbi_ber = [0.0, 0.0, 5.0000250001250005e-06, 5.8000290001450006e-05, 0.00029500147500737504, 0.0011230056150280752, 0.0033700168500842504, 0.00845004225021125, 0.018280091400457003, 0.03335116675583378, 0.052830264151320756, 0.07658738293691468, 0.1031155155775779, 0.12965864829324147, 0.15769278846394233, 0.18443492217461088, 0.2103120515602578, 0.2344121720608603, 0.25782828914144573, 0.2787913939569698]
fir_ber = [2.00001000005e-06, 2.5000125000625e-05, 0.00013500067500337503, 0.00048700243501217504, 0.0016480082400412003, 0.00435002175010875, 0.009475047375236877, 0.017873089365446827, 0.030570152850764254, 0.047592237961189804, 0.0684723423617118, 0.09205346026730134, 0.11858659293296467, 0.14479672398361992, 0.17338286691433458, 0.20063400317001584, 0.2271441357206786, 0.25191625958129793, 0.27671038355191774, 0.2976914884574423]
dfe_ber = [0.0, 3.0000150000750004e-06, 2.9000145000725003e-05, 0.00016400082000410002, 0.0007420037100185501, 0.0024680123400617005, 0.006165030825154126, 0.013156065780328902, 0.024928124640623203, 0.04153720768603843, 0.06214331071655358, 0.08618543092715464, 0.11298256491282456, 0.13936469682348412, 0.1672038360191801, 0.1939479697398487, 0.21975009875049376, 0.2441322206611033, 0.2674963374816874, 0.28893744468722343]
fwdbwd_ber = [0.0, 1.000010000100001e-06, 6.000060000600006e-06, 5.200052000520005e-05, 0.0002490024900249002, 0.0011210112101121012, 0.0032890328903289034, 0.008682086820868209, 0.018353183531835317, 0.03292832928329283, 0.05170251702517025, 0.07537775377753778, 0.1011980119801198, 0.12880128801288013, 0.15589155891558915, 0.18206682066820667, 0.20730007300073, 0.23215832158321584, 0.25574555745557453, 0.2770657706577066]
fwd_ber = [0.0, 2.000020000200002e-06, 2.5000250002500026e-05, 0.00016900169001690018, 0.0006640066400664007, 0.002341023410234102, 0.005675056750567506, 0.012698126981269812, 0.024056240562405625, 0.03991539915399154, 0.05981659816598166, 0.08397583975839758, 0.11012310123101231, 0.13826538265382654, 0.16558065580655806, 0.1924589245892459, 0.21820018200182, 0.24368443684436844, 0.26763467634676347, 0.2891278912789128]

viterbi_ol_ber=[0.0010350051750258752, 0.0034780173900869505, 0.008766043830219152, 0.018130090650453252, 0.03278616393081965, 0.05305926529632648, 0.07671738358691793, 0.10287851439257197, 0.1300036500182501, 0.15740678703393518, 0.1845799228996145]
viterbi_ol_pre_ber = [0.005718028590142951, 0.010043050215251077, 0.018109090545452726, 0.031118155590777952, 0.04974024870124351, 0.07252636263181315, 0.09872649363246816, 0.1257436287181436, 0.15260976304881524, 0.17905489527447638, 0.20456302281511407]

fwdbwd_ber_pre = [0.0, 2.000020000200002e-06, 1.1000110001100012e-05, 0.0001240012400124001, 0.0007090070900709007, 0.0023480234802348023, 0.006527065270652706, 0.015174151741517415, 0.02887228872288723, 0.04803448034480345, 0.07210272102721027, 0.098029980299803, 0.12510725107251072, 0.15138051380513806, 0.17726077260772607, 0.2024860248602486, 0.22491324913249133, 0.24734847348473485, 0.26881168811688116, 0.28795387953879537]
fwd_ber_pre=[0.15744857448574487, 0.18579985799857998, 0.2117851178511785, 0.23874438744387444, 0.26665266652666525, 0.2926039260392604, 0.3198341983419834, 0.34713647136471365, 0.3727517275172752, 0.3964979649796498, 0.41809818098180984, 0.4334023340233402, 0.44526445264452646, 0.45353753537535374, 0.45907159071590714, 0.46174961749617494, 0.46352963529635294, 0.4659726597265973, 0.46721167211672116, 0.4690086900869009]


fir_1_04 = [1.000005000025e-06, 1.2000060000300002e-05, 7.5000375001875e-05, 0.00035300176500882504, 0.0012420062100310502, 0.0037100185500927503, 0.008193040965204826, 0.016069080345401728, 0.02849514247571238, 0.04470122350611753, 0.065240326201631, 0.08868644343221715, 0.11455857279286397, 0.141799708998545, 0.17034685173425868, 0.19754598772993864, 0.2233161165805829, 0.24930424652123262, 0.27329436647183236, 0.29630148150740754]
dfe_1_04 = [0.0, 2.00001000005e-06, 2.2000110000550003e-05, 0.00012100060500302501, 0.0005970029850149251, 0.0020210101050505253, 0.00524602623013115, 0.011540057700288502, 0.02219711098555493, 0.03774318871594358, 0.05731928659643298, 0.08058640293201466, 0.10632453162265812, 0.13330966654833273, 0.1610168050840254, 0.18823094115470576, 0.2135120675603378, 0.23875819379096896, 0.2627963139815699, 0.2857124285621428]
viterbi_1_04 = [0.0, 0.0, 5.000270014580788e-06, 3.30017820962332e-05, 0.0002470133387202909, 0.0008920481706012125, 0.0029551595786172454, 0.007560408262046151, 0.015962861994547706, 0.029542595300146208, 0.04775257863924652, 0.07010778582043431, 0.09515513837747239, 0.12237260812083853, 0.14979108871879082, 0.17718956823668477, 0.20262594180085725, 0.227617291333732, 0.252296624017697, 0.274624829740806]
fwdbwd_1_04 = [0.0, 0.0, 5.000050000500005e-06, 3.300033000330003e-05, 0.0002460024600246002, 0.0008950089500895009, 0.002939029390293903, 0.007503075030750307, 0.015918159181591816, 0.02935729357293573, 0.04732347323473235, 0.06927269272692727, 0.09416994169941699, 0.12079120791207912, 0.14834148341483414, 0.17503575035750357, 0.2006320063200632, 0.22571025710257103, 0.25054850548505486, 0.272779727797278]
fwd_1_04 = [0.0, 2.000020000200002e-06, 1.9000190001900018e-05, 0.00011600116001160011, 0.0005550055500555005, 0.001875018750187502, 0.004897048970489705, 0.010983109831098311, 0.02131321313213132, 0.03639336393363934, 0.05558855588555885, 0.07875778757787578, 0.1046850468504685, 0.13150431504315044, 0.15958959589595895, 0.1870368703687037, 0.2125321253212532, 0.23807138071380715, 0.26230262302623025, 0.28535485354853546]

fir_1_02 = [0.0, 1.000005000025e-06, 9.000045000225e-06, 7.300036500182501e-05, 0.00034000170000850004, 0.001240006200031, 0.0033690168450842255, 0.0079120395601978, 0.015797078985394928, 0.02776113880569403, 0.04365421827109135, 0.06383731918659594, 0.08738343691718459, 0.11326956634783174, 0.14066570332851663, 0.16858184290921455, 0.19544497722488613, 0.22260711303556519, 0.24821524107620538, 0.27280536402682015]
dfe_1_02 = [0.0, 1.000005000025e-06, 4.0000200001e-06, 5.300026500132501e-05, 0.00028100140500702506, 0.001029005145025725, 0.0029500147500737504, 0.0071250356251781255, 0.014598072990364952, 0.026423132115660577, 0.04216321081605408, 0.06230231151155756, 0.08582842914214571, 0.11149555747778739, 0.13895869479347397, 0.16682983414917074, 0.19354996774983874, 0.22026510132550664, 0.24570322851614257, 0.270281351406757]
viterbi_1_02 = [0.0, 0.0, 5.000270014580788e-06, 3.7001998107897825e-05, 0.00022301204265030313, 0.0007970430403241775, 0.0024841341432437353, 0.006288339570336798, 0.013323719480851965, 0.024587327715696647, 0.04030117626351823, 0.06002124114702194, 0.08321549363665638, 0.10918489598438316, 0.13659937636632377, 0.16420086684680973, 0.19080830364839702, 0.2177437581629408, 0.24344514603788606, 0.2675414472381509]
fwdbwd_1_02 = [0.0, 0.0, 5.000050000500005e-06, 3.700037000370004e-05, 0.00022200222002220023, 0.0007970079700797008, 0.0024780247802478027, 0.006296062960629606, 0.013307133071330713, 0.024545245452454525, 0.04016440164401644, 0.05982059820598206, 0.08302083020830209, 0.1087750877508775, 0.13602736027360274, 0.16351563515635156, 0.19028190281902818, 0.21696116961169612, 0.24296342963429635, 0.26703867038670387]
fwd_1_02 = [0.0, 1.000010000100001e-06, 4.000040000400004e-06, 5.4000540005400054e-05, 0.0002810028100281003, 0.001020010200102001, 0.002930029300293003, 0.007053070530705307, 0.014503145031450315, 0.026219262192621925, 0.04186341863418634, 0.06198061980619806, 0.08546485464854649, 0.11115411154111542, 0.13864138641386414, 0.16650866508665085, 0.19333193331933318, 0.2201012010120101, 0.24563645636456363, 0.27022770227702275]

nnfwdbwd_1_04_02_01_6dB = [ 0.0, 2e-06, 5e-06, 7e-05, 0.000334, 0.001393, 0.003776, 0.00941, 0.019119, 0.033516, 0.051871, 0.075269, 0.101084, 0.128533, 0.155807, np.nan, np.nan, np.nan, np.nan, np.nan,]
nnfwdbwd_1_04_02_01_10dB = [0.0, 1e-06, 8e-06, 9.1e-05, 0.000427, 0.001646, 0.004259, 0.010278, 0.020529, 0.035439, 0.054291, 0.07776, 0.103298, 0.131329, 0.158662,np.nan, np.nan, np.nan, np.nan, np.nan,]




fir_ber_hr = [0.11708, 0.066904, 0.030214, 0.009075, 0.001542, 0.000112, 1e-06]
dfe_ber_hr = [0.112492, 0.062394, 0.02475, 0.006121, 0.000729, 3.1e-05, 1e-06]
viterbi_ber_hr = [0.103256, 0.053034, 0.01827, 0.003316, 0.000233, 4e-06]
snr_fir_ber_hr = [3, 5, 7, 9, 11, 13, 15]
snr_dfe_ber_hr = [3, 5, 7, 9, 11, 13, 15]
snr_viterbi_ber_hr = [3, 5, 7, 9, 11, 13]

snr_40_0 = np.arange(40,0,-2)
pam8_fir = [0.0, 0.0, 5.0000250001250005e-06, 5.5000275001375006e-05, 0.000541002705013525, 0.0027620138100690503, 0.010406052030260151, 0.03036715183575918, 0.07019835099175496, 0.13320666603333017, 0.21548907744538723, 0.3062715313576568, 0.3968919844599223, 0.48083340416702086, 0.5542997714988575, 0.616081080405402, 0.6680053400267001, 0.70840254201271, 0.7426117130585653, 0.7697118485592428]

pam8_dfe = [0.0, 0.0, 0.0, 0.0, 0.0, 3.7000185000925005e-05, 0.00122200611003055, 0.011095055475277376, 0.04659723298616493, 0.11638258191290957, 0.20697503487517438, 0.30198550992754963, 0.3936629683148416, 0.47733538667693337, 0.5507497537487688, 0.6127540637703188, 0.6640463202316012, 0.7052685263426317, 0.7392346961734809, 0.7660878304391522]

pam4_fir = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.600023000115001e-05, 0.0006840034200171001, 0.005367026835134176, 0.022324111620558102, 0.061076305381526905, 0.12279961399806999, 0.2001040005200026, 0.2819294096470482, 0.36102280511402557, 0.4315351576757884, 0.49209846049230244, 0.54280071400357]

pam4_dfe = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.000005000025e-06, 0.00011500057500287502, 0.0023310116550582754, 0.015457077285386428, 0.05393426967134836, 0.12006260031300156, 0.199519997599988, 0.2804474022370112, 0.3576497882489412, 0.4271771358856794, 0.4868324341621708, 0.5369786848934245]

pam4_fwdBwd = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.100031000310003e-05, 0.001110011100111001, 0.01031810318103181, 0.04409144091440914, 0.1087510875108751, 0.18924089240892408, 0.27095670956709567, 0.3486244862448625, 0.41781117811178115, 0.4778647786477865, 0.5278072780727807]


nrz_fir = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5000075000375002e-05, 0.0004450022250111251, 0.0040530202651013255, 0.017217086085430426, 0.046584232921164606, 0.09112545562727814, 0.14437672188360942]

nrz_dfe = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0000250001250005e-06, 0.0001440007200036, 0.0023080115400577004, 0.013390066950334751, 0.04132120660603303, 0.08631843159215796, 0.1398716993584968]

#nrz_vit = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.2000504006048076e-05, 0.0010150121801461617, 0.008577102925235103, 0.03284039408472902, 0.0765909190910291, 0.1301055612667352]
nrz_vit = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.20021841135739e-05, 0.0010150527827447026, 0.008577446027193415, 0.03284170776880398, 0.07659298283510743, 0.130105765499806]


nrz_fwdBwd = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.200042000420004e-05, 0.001011010110101101, 0.00859708597085971, 0.03265232652326523, 0.07573875738757388, 0.12838628386283862]


nn_nrz_20dB = [0.0, 0.0, 0.0, 5e-06, 0.000146, 0.002012, 0.011216, 0.036816, 0.079237, 0.131521]
nn_nrz_18dB = [0.0, 0.0, 0.0, 5e-06, 0.000144, 0.002139, 0.011378, 0.037441, 0.080233, 0.133044]
nn_nrz_16dB = [0.0, 0.0, 0.0, 8e-06, 0.000152, 0.002182, 0.011534, 0.037568, 0.080742, 0.133067]
nn_nrz_14dB = [0.0, 0.0, 0.0, 3e-06, 0.000134, 0.00192, 0.01077, 0.036505, 0.078969, 0.131191]
nn_nrz_12dB = [0.0, 0.0, 0.0, 3e-06, 0.000124, 0.001856, 0.010464, 0.036033, 0.078203, 0.1303]
nn_nrz_10dB = [0.0, 0.0, 0.0, 2e-06, 0.000122, 0.001881, 0.010654, 0.036406, 0.07873, 0.13131]
nn_nrz_8dB = [0.0, 0.0, 0.0, 2e-06, 9.7e-05, 0.001696, 0.010155, 0.035387, 0.077597, 0.129784]
nn_nrz_6dB = [0.0, 0.0, 0.0, 0.0, 7.6e-05, 0.001545, 0.009553, 0.034311, 0.076337, 0.128383]
nn_nrz_4dB = [0.0, 0.0, 0.0, 1e-06, 9.3e-05, 0.001648, 0.009757, 0.034298, 0.075571, 0.126978]
nn_nrz_2dB = [0.0, 0.0, 0.0, 6e-06, 0.000199, 0.002354, 0.011344, 0.035868, 0.075788, 0.126299]




if 0:
	plt.figure(1)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=13)
	plt.xticks(fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr,viterbi_ber, '-^', label = 'VITERBI ')
	plt.plot(snr,fir_ber, '-d',  label = 'FFE (3-tap MMSE)')
	plt.plot(snr,dfe_ber, '-o',  label = 'DFE (3-tap)')
	plt.plot(snr,fwdbwd_ber, '-x',  label = 'FWDBWD')
	#plt.plot(snr,fwd_ber, '-v', label = 'FWD')
	plt.plot(snr,nnfwdbwd_1_04_02_01_6dB, '-h',  label = 'nnFWDBWD_6dB')
	plt.plot(snr,nnfwdbwd_1_04_02_01_10dB, '-*',  label = 'nnFWDBWD_10dB')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=3)
	plt.tight_layout(rect=[0,0,1,1])
	plt.savefig('berVSsnr_1_04_02_01.png')
	#plt.show()


if 0:
	plt.figure(4)
	plt.title('BER VS. SNR, 1M bits, SBR=[0.2 1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	#plt.plot(snr,viterbi_ber, '-^', label = 'VITERBI ')
	#plt.plot(snr,fir_ber, '-d',  label = 'FFE (3-tap MMSE)')
	#plt.plot(snr,dfe_ber, '-o',  label = 'DFE (3-tap)')
	plt.plot(snr,fwdbwd_ber_pre, '-x',  label = 'FWDBWD')
	plt.plot(snr,fwd_ber_pre, '-o',  label = 'FWD')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=4)
	plt.tight_layout(rect=[0,0,1,1])
	plt.savefig('berVSsnr_02_1_04_02_01.png')
	#plt.show()

if 0:
	plt.figure(5)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4]')
	plt.xlabel('SNR (dB)',fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr,viterbi_1_04, '-^', label = 'VITERBI ')
	plt.plot(snr,fir_1_04, '-d',  label = 'FFE (3-tap MMSE)')
	plt.plot(snr,dfe_1_04, '-o',  label = 'DFE (3-tap)')
	plt.plot(snr,fwdbwd_1_04, '-x',  label = 'FWDBWD')
	plt.plot(snr,fwd_1_04, '-o',  label = 'FWD')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=4)
	plt.tight_layout(rect=[0,0,1,1])
	plt.savefig('berVSsnr_1_04.png')
	#plt.show()

if 0:
	plt.figure(6)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.2]')
	plt.xlabel('SNR (dB)',fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr,viterbi_1_02, '-^', label = 'VITERBI ')
	plt.plot(snr,fir_1_02, '-d',  label = 'FFE (3-tap MMSE)')
	plt.plot(snr,dfe_1_02, '-o',  label = 'DFE (3-tap)')
	plt.plot(snr,fwdbwd_1_02, '-x',  label = 'FWDBWD')
	plt.plot(snr,fwd_1_02, '-o',  label = 'FWD')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=4)
	plt.tight_layout(rect=[0,0,1,1])
	plt.savefig('berVSsnr_1_02.png')
	#plt.show()


if 0: ################################################## 1
	plt.figure(7)
	plt.title('BER VS. SNR, NRZ/PAM4/PAM8 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_40_0,pam8_fir, '-^', label = 'PAM8 FIR')
	plt.plot(snr_40_0,pam8_dfe, '-d',  label = 'PAM8 DFE')
	plt.plot(snr_40_0,pam4_fir, '-o',  label = 'PAM4 FIR')
	plt.plot(snr_40_0,pam4_dfe, '-x',  label = 'PAM4 DFE')
	plt.plot(snr_40_0,pam4_fwdBwd, '-d',  label = 'PAM4 FwdBwd')
	plt.plot(snr_40_0,nrz_fir, '-o',  label = 'NRZ FIR')
	plt.plot(snr_40_0,nrz_dfe, '-v',  label = 'NRZ DFE')
	plt.plot(snr_40_0,nrz_vit, '-*',  label = 'NRZ VIT')
	plt.plot(snr_40_0,nrz_fwdBwd, '-^',  label = 'NRZ FwdBwd')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=4)
	plt.tight_layout(rect=[0,0,1,1])
	plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir.png')
	#plt.show()



##########################################################
# Graph for 1
if (1 in make_plot): ##################################################@@
	snr_20_0 = np.arange(20,0,-2)
	nrz_fir =\
	[0.0, 0.0, 0.0, 2.1000105000525004e-05, 0.00048500242501212505, 0.004097020485102426, 0.017348086740433703, 0.04670123350616753, 0.09073045365226826, 0.14414672073360366]
	
	nrz_dfe =\
	[0.0, 0.0, 0.0, 3.0000150000750004e-06, 0.00016000080000400002, 0.0023140115700578502, 0.013411067055335277, 0.04168320841604208, 0.08581542907714539, 0.13914669573347865]
	
	nrz_vit =\
	[0.0, 0.0, 0.0, 0.0, 3.800197610275734e-05, 0.0010700556428934304, 0.008563445299155556, 0.03324772888190186, 0.07609195678175265, 0.1293607267577914]
	
	nrz_fwdBwd =\
	[0.0, 0.0, 0.0, 0.0, 3.900039000390004e-05, 0.001068010680106801, 0.008584085840858409, 0.032988329883298834, 0.07505875058750587, 0.12769827698276984]

	plt.figure(1)
	plt.title('BER VS. SNR, NRZ 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_20_0,nrz_fir, '-o',  label = 'NRZ FIR')
	plt.plot(snr_20_0,nrz_dfe, '-v',  label = 'NRZ DFE')
	plt.plot(snr_20_0,nrz_vit, '-*',  label = 'NRZ VIT')
	plt.plot(snr_20_0,nrz_fwdBwd, '-^',  label = 'NRZ FwdBwd')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
#	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
#	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
#	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
#	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
#	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('1.png')
	#plt.cla()
	##plt.show()

#######################################
# Graph for 2
if (2 in make_plot): ##################################################@@
	snr_20_0 = np.arange(20,0,-2)
	nrz_fir =\
	[0.0, 1.7000085000425003e-05, 0.00029600148000740004, 0.002677013385066925, 0.011922059610298052, 0.03449117245586228, 0.07271936359681798, 0.12258861294306471, 0.17781688908444543, 0.2295001475007375]

	nrz_dfe =\
	[0.0, 0.0, 2.4000120000600003e-05, 0.0006950034750173751, 0.004575022875114376, 0.017565087825439127, 0.042694213471067353, 0.07861939309696549, 0.12370661853309267, 0.17048085240426203]

	nrz_firdfe =\
	[0.0, 0.0, 0.0, 0.00026100130500652505, 0.0025930129650648254, 0.012629063145315726, 0.03802519012595063, 0.07951739758698793, 0.13256866284331423, 0.18510092550462753]
	
	nrz_vit =\
	[0.0, 0.0, 0.0, 4.000212011236596e-06, 0.00019701044155340233, 0.003136166216809491, 0.018561983785140613, 0.05539093571959314, 0.10726968529332055, 0.16030849635030656]

	nrz_fwdBwd =\
	[0.0, 0.0, 0.0, 4.000040000400004e-06, 0.0002100021000210002, 0.0032080320803208034, 0.01871518715187152, 0.054764547645476454, 0.10540705407054071, 0.15654256542565426]

	plt.figure(2)
	#plt.title('BER VS. SNR, NRZ 1M bits, SBR=[0.3 1 0.4]')
	plt.title('BER VS. SNR, NRZ bits, SBR=[0.3 1 0.4]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_20_0,nrz_fir, '-o',  label = 'NRZ FIR')
	plt.plot(snr_20_0,nrz_dfe, '-v',  label = 'NRZ DFE')
	plt.plot(snr_20_0,nrz_firdfe, '-d',  label = 'NRZ FIRDFE')
	plt.plot(snr_20_0,nrz_vit, '-*',  label = 'NRZ VIT')
	plt.plot(snr_20_0,nrz_fwdBwd, '-^',  label = 'NRZ FwdBwd')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
#	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
#	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
#	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
#	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
#	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('2.png')
	#plt.cla()
	plt.show()


##############################################################################
#######################################
# Graph for 8
if (8 in make_plot): ##################################################@@
	snr_30_0 = np.arange(30,0,-2)
	pam4_fir =\
	[0.0, 0.0, 0.0, 3.100015500077501e-05, 0.0006780033900169501, 0.005261026305131525, 0.022282111410557054, 0.060829304146520734, 0.12264361321806609, 0.20005700028500142, 0.28229041145205724, 0.3606848034240171, 0.4307961539807699, 0.49230546152730764, 0.5425407127035635]

	pam4_dfe =\
	[0.0, 0.0, 0.0, 1.000005000025e-06, 0.000127000635003175, 0.002263011315056575, 0.015208076040380202, 0.054010270051350256, 0.11962759813799069, 0.19955399776998886, 0.28113740568702844, 0.3578647893239466, 0.42616413082065413, 0.487440437202186, 0.5367526837634188]

	pam4_fwdBwd =\
	[0.0, 0.0, 0.0, 0.0, 2.2000220002200024e-05, 0.001020010200102001, 0.01021310213102131, 0.044303443034430345, 0.10840308403084031, 0.1891488914889149, 0.27131071310713106, 0.34846748467484673, 0.4169421694216942, 0.4782487824878249, 0.5273572735727358]

	plt.figure(1)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_30_0,pam4_fir, '-o',  label = 'PAM4 FIR')
	plt.plot(snr_30_0,pam4_dfe, '-v',  label = 'PAM4 DFE')
	plt.plot(snr_30_0,pam4_fwdBwd, '-^',  label = 'PAM4 FwdBwd')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
#	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
#	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
#	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
#	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
#	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('8.png')
	#plt.cla()
	##plt.show()

##############################################################################
#######################################
# Graph for 11 : PAM4 Real Channel fir, dfe, firDfe, fwdBwd
if (11 in make_plot): ##################################################@@
	snr_50_0 = np.arange(50,0,-2)
	pam4_fir =\
[0.1979629898149491, 0.1979639898199491, 0.19791898959494797, 0.19826899134495674, 0.1983799918999595, 0.1989039945199726, 0.1995919979599898, 0.2005040025200126, 0.20217101085505426, 0.20524202621013105, 0.2091120455602278, 0.21558607793038964, 0.22538312691563459, 0.24022620113100565, 0.2620433102165511, 0.2897144485722429, 0.32862364311821557, 0.3721288606443032, 0.4217841089205446, 0.47130935654678274, 0.5194465972329861, 0.5593917969589848, 0.5960369801849009, 0.6264891324456622, 0.6508702543512718]

	pam4_dfe =\
[0.48638743193715966, 0.48576942884714425, 0.48552642763213816, 0.4853764268821344, 0.4851894259471297, 0.4851464257321287, 0.48494542472712365, 0.4847034235171176, 0.48448242241211203, 0.48369941849709247, 0.4836424182120911, 0.48528642643213216, 0.48646143230716155, 0.4894124470622353, 0.4912314561572808, 0.4934294671473357, 0.496120480602403, 0.499040495202476, 0.5058945294726473, 0.516839584197921, 0.5321956609783048, 0.5513327566637833, 0.5735538677693388, 0.5958529792648963, 0.6170990854954275]

	pam4_firDfe =\
[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.000005000025e-06, 7.000035000175001e-06, 0.0001560007800039, 0.0015220076100380502, 0.008369041845209226, 0.029104145520727605, 0.07257236286181432, 0.13682868414342073, 0.21493707468537343, 0.2963394816974085, 0.3737058685293426, 0.4430552152760764, 0.5010495052475262, 0.5509067545337727, 0.5898329491647458, 0.6221461107305537, 0.6487912439562198, 0.6687323436617183]

	pam4_fwdBwd =\
[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.00009000090001e-06, 0.0002150021500215002, 0.001902019020190202, 0.011713117131171312, 0.043318433184331845, 0.10793307933079331, 0.1982759827598276, 0.2893418934189342, 0.36446864468644685, 0.42052220522205225, 0.4666806668066681, 0.5035750357503576, 0.5357813578135782, 0.5630956309563095, 0.5874168741687417]

	plt.figure(11)
	plt.title('BER VS. SNR, 1M bits, Real Channel 24dB Loss')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_50_0,pam4_fir, '-o',  label = 'PAM4 FIR')
	plt.plot(snr_50_0,pam4_dfe, '-v',  label = 'PAM4 DFE')
	plt.plot(snr_50_0,pam4_firDfe, '-^',  label = 'PAM4 FIRDFE')
	plt.plot(snr_50_0,pam4_fwdBwd, '-d',  label = 'PAM4 FwdBwd')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
#	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
#	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
#	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
#	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
#	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('11.png')
	#plt.cla()
	##plt.show()

#######################################
# Graph for 11 : PAM4 Real Channel fir, dfe, firDfe, fwdBwd
if (12 in make_plot): ##################################################@@
	snr_40_10 = np.arange(40,10,-2)
	pam4_fir =\
[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.1000055000275001e-05, 0.00044700223501117507, 0.00445802229011145, 0.02188110940554703, 0.061990309951549756, 0.12666563332816663, 0.20524602623013116]
	pam4_dfe =\
[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.00001000005e-06, 0.00018300091500457501, 0.0027190135950679755, 0.018021090105450527, 0.05941629708148541, 0.12826564132820664, 0.20745403727018635]
	pam4_nnfwdBwd =\
[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2e-06, 8e-05, 0.001632, 0.013294, 0.050265, 0.116787, 0.196595]

	plt.figure(11)
	plt.title('BER VS. SNR, 1M bits, Real Channel 24dB Loss')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_40_10,pam4_fir, '-o',  label = 'PAM4 FIR')
	plt.plot(snr_40_10,pam4_dfe, '-v',  label = 'PAM4 DFE')
	plt.plot(snr_40_10,pam4_nnfwdBwd, '-d',  label = 'PAM4 FwdBwd')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_ber), '-o', label = 'VITERBI OVERLAP')
#	#plt.plot(np.arange(10,-1,-1),np.array(viterbi_ol_pre_ber), '-v', label = 'VITERBI OVERLAP 0.2 1.0 0.4 0.1')
#	#plt.plot(snr_viterbi_ber_hr,np.array(viterbi_ber_hr)*1, '-o', label = 'VITERBI HR')
#	#plt.plot(snr_fir_ber_hr,np.array(fir_ber_hr)*1, '-o',  label = 'FFE (3-tap MMSE) HR')
#	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
#	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
#	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	plt.xlim([10,30])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('12.png')
	#plt.cla()
	##plt.show()


##########################################################
# Graph for 101 : fir, dfe, fwdBwd, nn for NRZ + PAM4 
if (101 in make_plot): ##################################################@@
	snr_20_0 = np.arange(20,0,-2)
	nrz_fir =\
	[0.0, 0.0, 0.0, 2.1000105000525004e-05, 0.00048500242501212505, 0.004097020485102426, 0.017348086740433703, 0.04670123350616753, 0.09073045365226826, 0.14414672073360366]
	nrz_dfe =\
	[0.0, 0.0, 0.0, 3.0000150000750004e-06, 0.00016000080000400002, 0.0023140115700578502, 0.013411067055335277, 0.04168320841604208, 0.08581542907714539, 0.13914669573347865]
	nrz_vit =\
	[0.0, 0.0, 0.0, 0.0, 3.800197610275734e-05, 0.0010700556428934304, 0.008563445299155556, 0.03324772888190186, 0.07609195678175265, 0.1293607267577914]
	nrz_fwdBwd =\
	[0.0, 0.0, 0.0, 0.0, 3.900039000390004e-05, 0.001068010680106801, 0.008584085840858409, 0.032988329883298834, 0.07505875058750587, 0.12769827698276984]
	nrz_nn =\
	[0.0, 0.0, 0.0, 0.0, 7.1e-05, 0.001437, 0.009927, 0.034083, 0.077022, 0.129579]	
	# snr: 8
	#[0.0, 0.0, 0.0, 0.0, 6.8e-05, 0.001473, 0.01002, 0.034075, 0.076693, 0.129294]	
	# snr: 6
	#[0.0, 0.0, 0.0, 0.0, 8.5e-05, 0.001513, 0.010108, 0.034649, 0.077297, 0.130174]
	# snr: 18
	#[0.0, 0.0, 0.0, 2e-06, 7.5e-05, 0.001369, 0.00986, 0.034701, 0.077912, 0.131142]
	# snr: 14

	snr_30_0 = np.arange(30,0,-2)
	pam4_fir =\
	[0.0, 0.0, 0.0, 3.100015500077501e-05, 0.0006780033900169501, 0.005261026305131525, 0.022282111410557054, 0.060829304146520734, 0.12264361321806609, 0.20005700028500142, 0.28229041145205724, 0.3606848034240171, 0.4307961539807699, 0.49230546152730764, 0.5425407127035635]
	pam4_dfe =\
	[0.0, 0.0, 0.0, 2.00001000005e-06, 0.000127000635003175, 0.0023060115300576503, 0.015741078705393527, 0.054246271231356155, 0.11996459982299912, 0.20007100035500178, 0.28071640358201794, 0.3582217911089555, 0.42727113635568176, 0.48686443432217164, 0.5363506817534087]
	pam4_fwdBwd=\
	[0.0, 0.0, 0.0, 0.0, 2.2000220002200024e-05, 0.001020010200102001, 0.01021310213102131, 0.044303443034430345, 0.10840308403084031, 0.1891488914889149, 0.27131071310713106, 0.34846748467484673, 0.4169421694216942, 0.4782487824878249, 0.5273572735727358]
	pam4_nn = \
	[0.0, 0.0, 0.0, 1e-06, 0.000108, 0.001929, 0.013408, 0.048307, 0.111329, 0.19068, 0.272989, 0.351273, 0.420494, 0.480486, 0.530534]
	 # Best snr is 26
	 # Best snr is 20
	 #[0.0, 0.0, 0.0, 2e-06, 0.000121, 0.001936, 0.013429, 0.048097, 0.111407, 0.190505, 0.273131, 0.351052, 0.419624, 0.480106, 0.530483]
	 # Best snr is 14 on 20dB (nnSnr = 20)
	#[0.0, 0.0, 0.0, 6e-06, 9.7e-05, 0.00183, 0.013244, 0.047406, 0.109243, 0.188683, 0.270835, 0.348528, 0.419031, 0.479613, 0.528659]


	plt.figure(3)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_20_0,nrz_fir, '-o',  label = 'NRZ FIR')
	plt.plot(snr_20_0,nrz_dfe, '-v',  label = 'NRZ DFE')
	plt.plot(snr_20_0,nrz_fwdBwd, '-d',  label = 'NRZ FWDBWD')
	plt.plot(snr_20_0,nrz_nn, '-*',  label = 'NRZ NN')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('1.png')
	#plt.cla()
	#

	plt.figure(3)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_30_0,pam4_fir, '-o',  label = 'PAM4 FIR')
	plt.plot(snr_30_0,pam4_dfe, '-v',  label = 'PAM4 DFE')
	plt.plot(snr_30_0,pam4_fwdBwd, '-d',  label = 'PAM4 FWDBWD')
	plt.plot(snr_30_0,pam4_nn, '-^',  label = 'PAM4 NN')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	#plt.cla()
	##plt.show()

	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('101.png')
	#plt.cla()
	##plt.show()

###########################################################
# Graph for 102 : TrainSnr sweep on various snr
if (102 in make_plot): ##################################################@@
	snr_20_0 = np.arange(20,0,-2)
	nrz_nn_snr20 =\
	[0.0, 0.0, 0.0, 3e-06, 0.000111, 0.001625, 0.010545, 0.035346, 0.078633, 0.131568]
	nrz_nn_snr18 =\
	[0.0, 0.0, 0.0, 0.0, 8.5e-05, 0.001513, 0.010108, 0.034649, 0.077297, 0.130174]
	nrz_nn_snr16 =\
	[0.0, 0.0, 0.0, 1e-06, 7.8e-05, 0.001455, 0.010004, 0.034598, 0.077421, 0.130573]
	nrz_nn_snr14 =\
	[0.0, 0.0, 0.0, 2e-06, 7.8e-05, 0.001391, 0.009967, 0.03449, 0.077622, 0.130754]
	nrz_nn_snr12 =\
	[0.0, 0.0, 0.0, 0.0, 8.2e-05, 0.001393, 0.009994, 0.0342, 0.077394, 0.129825]
	nrz_nn_snr10 =\
	[0.0, 0.0, 0.0, 0.0, 7.6e-05, 0.001432, 0.010044, 0.034341, 0.077334, 0.130118]	
	nrz_nn_snr8 =\
	[0.0, 0.0, 0.0, 0.0, 7.1e-05, 0.001437, 0.009927, 0.034083, 0.077022, 0.129579]	
	nrz_nn_snr6 =\
	[0.0, 0.0, 0.0, 0.0, 6.8e-05, 0.001473, 0.01002, 0.034075, 0.076693, 0.129294]	
	nrz_nn_snr4 =\
	[0.0, 0.0, 0.0, 2e-06, 9.1e-05, 0.001581, 0.010123, 0.03396, 0.075787, 0.128136]
	nrz_nn_snr2 =\
	[0.0, 0.0, 0.0, 8e-06, 0.000206, 0.002285, 0.011886, 0.035538, 0.075987, 0.126994]	

	snr_30_0 = np.arange(30,0,-2)
	pam4_nn_snr30 =\
	[0.0, 0.0, 0.0, 1e-06, 0.000119, 0.001988, 0.013502, 0.048187, 0.111226, 0.190454, 0.272936, 0.350766, 0.419362, 0.47994, 0.530318]
	pam4_nn_snr28 =\
	[0.0, 0.0, 0.0, 4e-06, 0.000131, 0.002017,0.013505, 0.048566, 0.111491, 0.190532, 0.273068, 0.351166, 0.419965, 0.480288, 0.530916]
	pam4_nn_snr26 =\
	[0.0, 0.0, 0.0, 1e-06, 0.000108, 0.001929, 0.013408, 0.048307, 0.111329, 0.19068, 0.272989, 0.351273, 0.420494, 0.480486, 0.530534]
	pam4_nn_snr24 =\
	[0.0, 0.0, 0.0, 2e-06, 0.000127, 0.002049, 0.013773, 0.048562, 0.111727, 0.191164, 0.273531, 0.351123, 0.420148, 0.480087, 0.530809]
	pam4_nn_snr22 =\
	[0.0, 0.0, 0.0, 3e-06, 0.000126, 0.001963, 0.013456, 0.048352, 0.111437, 0.191073, 0.273316, 0.351365, 0.419982, 0.479933, 0.530525]
	pam4_nn_snr20 =\
	[0.0, 0.0, 0.0, 2e-06, 0.000107, 0.002002, 0.013385, 0.048281, 0.110734, 0.190614, 0.272643, 0.350698, 0.420482, 0.479949, 0.530622]
	pam4_nn_snr18 =\
	[0.0, 0.0, 0.0, 3e-06, 0.00012, 0.001994, 0.013389, 0.048437, 0.110542, 0.189905, 0.272211, 0.350631, 0.42064, 0.480319, 0.530458]
	pam4_nn_snr16 =\
	[0.0, 0.0, 0.0, 2e-06, 0.000112, 0.001962, 0.013308, 0.047939, 0.110335, 0.189679, 0.271991, 0.350542, 0.420457, 0.479977, 0.530429]
	pam4_nn_snr14 =\
	[0.0, 0.0, 0.0, 3e-06, 9.6e-05, 0.001911, 0.01309, 0.047575, 0.108578, 0.187701, 0.270448, 0.349072, 0.419419, 0.479331, 0.529892]
	pam4_nn_snr12 =\
	[0.0, 0.0, 0.0, 1e-06, 0.000159, 0.002393, 0.014658, 0.0489, 0.108683, 0.186131, 0.268494, 0.347827, 0.418821, 0.479074, 0.529904]

	plt.figure(4)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_20_0,nrz_nn_snr20, '-o',  label = 'NRZ NN on SNR 20')
	plt.plot(snr_20_0,nrz_nn_snr16, '-v',  label = 'NRZ NN on SNR 16')
	plt.plot(snr_20_0,nrz_nn_snr12, '-*',  label = 'NRZ NN on SNR 12')
	plt.plot(snr_20_0,nrz_nn_snr8, '-d',  label = 'NRZ NN on SNR 8')
	plt.plot(snr_20_0,nrz_nn_snr4, '-x',  label = 'NRZ NN on SNR 4')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('1.png')
	#plt.cla()
	#

	plt.figure(4)
	plt.title('BER VS. SNR, 1M bits, SBR=[1 0.4 0.2 0.1]')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)

	plt.plot(snr_30_0,pam4_nn_snr30, '-o',  label = 'PAM4 NN on SNR 30')
	plt.plot(snr_30_0,pam4_nn_snr26, '-v',  label = 'PAM4 NN on SNR 26')
	plt.plot(snr_30_0,pam4_nn_snr22, '-*',  label = 'PAM4 NN on SNR 22')
	plt.plot(snr_30_0,pam4_nn_snr18, '-d',  label = 'PAM4 NN on SNR 18')
	plt.plot(snr_30_0,pam4_nn_snr14, '-x',  label = 'PAM4 NN on SNR 14')
	
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	#plt.cla()
	##plt.show()

	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('berVSsnr_1_04_02_01_modvar_dfe_fir_20_0.png')
	plt.savefig('102.png')
	#plt.cla()
	##plt.show()


##########################################################
# Graph for 103: PAM4 real channel, firDfe vs nnFwdBwd
if (103 in make_plot): ##################################################@@
	snr_50_0 = np.arange(50,0,-2)
	pam4_firDfe =\
	[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.000005000025e-06, 7.000035000175001e-06, 0.0001560007800039, 0.0015220076100380502, 0.008369041845209226, 0.029104145520727605, 0.07257236286181432, 0.13682868414342073, 0.21493707468537343, 0.2963394816974085, 0.3737058685293426, 0.4430552152760764, 0.5010495052475262, 0.5509067545337727, 0.5898329491647458, 0.6221461107305537, 0.6487912439562198, 0.6687323436617183]

	pam4_nn =\
	[0.000984, 0.000972, 0.000989, 0.00106, 0.001098, 0.001167, 0.001351, 0.001571, 0.001974, 0.002718, 0.004125, 0.006554, 0.011864, 0.025799, 0.057923, 0.117903, 0.202683, 0.288632, 0.365804, 0.425693, 0.473197, 0.517245, 0.568652, 0.631686, 0.689563]
	# Trained on SNR 30
	#[0.010956, 0.01096, 0.011158, 0.011244, 0.011764, 0.0122, 0.013105, 0.014607, 0.01713, 0.020756, 0.027177, 0.037662, 0.053706, 0.079742, 0.11539, 0.162311, 0.222171, 0.285831, 0.350751, 0.409212, 0.459622, 0.503119, 0.540363, 0.570616, 0.595458]
	# Trained on SNR 14
	
	plt.figure(5)
	plt.title('BER VS. SNR, 1M bits, Real Channel')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_50_0,pam4_firDfe, '-o',  label = 'PAM4 FIRDFE')
	plt.plot(snr_50_0,pam4_nn, '-v',  label = 'PAM4 NN')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('1.png')
	#plt.cla()
	#
	plt.savefig('103.png')
	#plt.cla()
	##plt.show()

##########################################################
# Graph for 104: Train with Simple data vs fwdBwd
if (104 in make_plot): ##################################################@@
	snr_20_0 = np.arange(20,0,-2)

	fwdBwd_nn_snr10 =\
	[0.0, 0.0, 0.0, 0.0, 7.6e-05, 0.001432, 0.010044, 0.034341, 0.077334, 0.130118]	
	simpData_nn_snr10 =\
	[0.0, 0.0, 0.0, 1e-06, 9.9e-05, 0.001551, 0.010464, 0.035224, 0.078271, 0.131607]

	plt.figure(6)
	plt.title('BER VS. SNR, 1M bits, Simple vs FwdBwd')
	plt.xlabel('SNR (dB)',fontsize=17)
	plt.xticks(fontsize=16)
	plt.ylabel('BER ',fontsize=17)
	plt.yticks(fontsize=16)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.grid(True)
	
	plt.plot(snr_20_0,simpData_nn_snr10, '-o',  label = 'NN SIMPLE')
	plt.plot(snr_20_0,fwdBwd_nn_snr10, '-v',  label = 'NN FWDBWD')
	plt.legend(bbox_to_anchor=(0.5,-0.2) , loc='upper center', ncol=2, fontsize=13)
	plt.tight_layout(rect=[0,0,1,1])
	#plt.savefig('1.png')
	#plt.cla()
	#
	plt.savefig('104.png')
	#plt.cla()
	##plt.show()





if 0:
	#snr10_vit_b_sweep = [0.0007003501750875437, 0.0007003501750875437, 0.0006003001500750375, 0.0010005002501250625, 0.0010005002501250625, 0.0011005502751375688, 0.0007003501750875437, 0.0014007003501750874, 0.0009004502251125563,]
	#snr8_vit_b_sweep =  [0.010005002501250625, 0.009304652326163081, 0.0096048024012006, 0.010205102551275639, 0.009804902451225613, 0.010805402701350676, 0.009704852426213106, 0.010505252626313157, 0.011805902951475739, ]
	#snr6_vit_b_sweep = [0.03601800900450225, 0.035317658829414705, 0.03671835917958979, 0.03501750875437719, 0.03501750875437719, 0.035817908954477236, 0.03631815907953977, 0.034817408704352175, 0.03611805902951476, ]
	#snr4_vit_b_sweep = [0.07603801900950476, 0.07513756878439219, 0.07623811905952976, 0.07613806903451725, 0.07623811905952976, 0.07533766883441721, 0.07633816908454227, 0.07643821910955478, 0.07773886943471736, ]
	#snr2_vit_b_sweep = [0.13546773386693348, 0.13576788394197098, 0.1343671835917959, 0.13566783391695847, 0.13496748374187093, 0.13646823411705852, 0.1345672836418209, 0.1358679339669835, 0.13806903451725863]
	
	#snr10_vit_b_sweep = [0.0013006503251625813, 0.0009004502251125563, 0.0016008004002001002, 0.0017008504252126063, 0.002301150575287644]
	#snr5_vit_b_sweep = [0.05582791395697849, 0.05692846423211606, 0.05652826413206603, 0.05972986493246623, 0.06143071535767884]
	#snr0_vit_b_sweep = [0.18469234617308655, 0.1824912456228114, 0.1823911955977989, 0.18649324662331165, 0.19189594797398699]
	
	## 1.0 0.4 0.2
	snr10_vit_b_sweep= [0.0007003501750875437, 0.0007003501750875437, 0.0008004002001000501, 0.0009004502251125563, 0.0009004502251125563, 0.0009004502251125563, 0.0009004502251125563, 0.0008004002001000501, 0.0010005002501250625, 0.0011005502751375688, 0.0009004502251125563, 0.001200600300150075]
	
	snr5_vit_b_sweep= [0.05002501250625312, 0.05022511255627814, 0.05032516258129065, 0.05102551275637819, 0.05092546273136568, 0.05202601300650325, 0.05102551275637819, 0.05182591295647824, 0.052126063031515756, 0.052626313156578286, 0.05342671335667834, 0.05942971485742871]
	
	snr0_vit_b_sweep= [0.1790895447723862, 0.1791895947973987, 0.18039019509754878, 0.17988994497248625, 0.17988994497248625, 0.17968984492246123, 0.18109054527263632, 0.17998999499749874, 0.18029014507253627, 0.18139069534767382, 0.18159079539769885, 0.18159079539769885]
	
	
	## 0.2 1.0 0.4
	snr10_vit_b_sweep2= [0.0009004502251125563, 0.005302651325662831, 0.021410705352676338, 0.022611305652826413, 0.022611305652826413, 0.030115057528764384, 0.03171585792896448, 0.0384192096048024, 0.05022511255627814, 0.06463231615807905, 0.10445222611305653, 0.2675337668834417]
	
	
	snr5_vit_b_sweep2= [0.06283141570785393, 0.06633316658329165, 0.0831415707853927, 0.08894447223611805, 0.08774387193596798, 0.09804902451225612, 0.096048024012006, 0.1055527763881941, 0.11435717858929464, 0.1327663831915958, 0.17248624312156077, 0.30035017508754375]
	
	
	
	snr0_vit_b_sweep2= [0.19479739869934967, 0.19739869934967483, 0.20910455227613806, 0.20930465232616308, 0.21410705352676337, 0.21460730365182593, 0.21780890445222612, 0.22201100550275138, 0.23231615807903952, 0.24452226113056527, 0.2656328164082041, 0.3389694847423712]
	
	
	## 0.2 1.0 0.4 overal viterbi
	snr10_vit_b_sweep3 = [0.0010008006405124099, 0.0009047954157032271, 0.0009011715229798738, 0.0009010812975570685, 0.0009009910901992192, 0.0009009009009009009, 0.000900810729656691, 0.000900720576461169, 0.0009006304413089162, 0.0009005403241945167, 0.0014007003501750874, 0.004702351175587794]
	
	snr5_vit_b_sweep3 = [0.06405124099279423, 0.06283301497939077, 0.06308200660859117, 0.0630756908289948, 0.06306937631394534, 0.06306306306306306, 0.06325693123811431, 0.06365092073658928, 0.06384469128389873, 0.06363818290974585, 0.06503251625812906, 0.07263631815907955]
	
	snr0_vit_b_sweep3 = [0.19875900720576462, 0.1972454006233035, 0.19765695404025233, 0.197637164597517, 0.19761737911702873, 0.1975975975975976, 0.19757782003803423, 0.19755804643714972, 0.197037926548584, 0.1976185711426856, 0.19919959979989996, 0.20060030015007504]





	plt.figure(2)
	plt.title('BER VS. VITERBI BLOCK SIZE')
	plt.xlabel('Block size',fontsize=13)
	plt.ylabel('BER ',fontsize=13)
	#plt.ylim([0.8,10])
	plt.yscale('log')
	plt.xscale('log')
	plt.grid(True)
	
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr10_vit_b_sweep, '-^', label = 'SNR 10dB ')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr5_vit_b_sweep, '-v',  label = 'SNR 5dB')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr0_vit_b_sweep, '-o',  label = 'SNR 0dB')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr10_vit_b_sweep2, '--^', label = 'SNR 10dB ')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr5_vit_b_sweep2, '--d',  label = 'SNR 5dB')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr0_vit_b_sweep2, '--o',  label = 'SNR 0dB')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr10_vit_b_sweep3, '-ok', label = 'SNR 10dB ')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr5_vit_b_sweep3, '-ok', label = 'SNR 10dB ')
	plt.plot(np.append([10000,100],np.arange(20,0,-2)),snr0_vit_b_sweep3, '-ok', label = 'SNR 10dB ')
	#plt.plot(np.arange(20,2,-2),snr4_vit_b_sweep, '-x', label = 'SNR 4dB')
	#plt.plot(np.arange(20,2,-2),snr2_vit_b_sweep, '-v',  label = 'SNR 2dB')
	#plt.plot(snr_dfe_ber_hr,np.array(dfe_ber_hr)*1, '-o',  label = 'DFE (3-tap) HR')
	#plt.plot(t,le_ann,'k--', markevery=30, label='ANN')
	#plt.legend(bbox_to_anchor=(1.04,0.5) , loc='center left')
	plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=2)
	plt.tight_layout(rect=[0,0,1,1])
	plt.show()
#


#vit_delete = [0.0008004002001000501, 0.0029014507253626812, 0.008204102051025513, 0.012706353176588294, 0.027613806903451724, 0.039319659829914956, 0.05712856428214107, 0.0832416208104052, 0.10835417708854428, 0.13676838419209605, 0.15767883941970987, 0.19429714857428715, 0.2147073536768384, 0.2463231615807904, 0.27313656828414207]
#
#vit_nodelete = [0.0010005002501250625, 0.0029014507253626812, 0.008504252126063032, 0.01310655327663832, 0.027613806903451724, 0.039419709854927466, 0.05712856428214107, 0.0832416208104052, 0.10925462731365683, 0.13706853426713356, 0.15797898949474737, 0.1949974987493747, 0.21510755377688845, 0.24732366183091545, 0.2718359179589795]
#
#
#
#
#
#plt.figure(3)
#plt.title('BER VS. SNR VITERBI transfer method')
#plt.xlabel('SNR',fontsize=13)
#plt.ylabel('BER ',fontsize=13)
##plt.ylim([0.8,10])
#plt.yscale('log')
#plt.grid(True)
#
#plt.plot(np.arange(10,-5,-1),vit_delete, '-^', label = 'vit delete ')
#plt.plot(np.arange(10,-5,-1),vit_nodelete, '-v',  label = 'vit nodelete')
#plt.legend(bbox_to_anchor=(0.5,-0.12) , loc='upper center', ncol=2)
#plt.tight_layout(rect=[0,0,1,1])
#plt.show()
##
